import './jquery-ui-1.12.1.custom/jquery-ui.min.css';
import './jquery';
import './jquery-ui-1.12.1.custom/jquery-ui.min';

const servicesElt = document.querySelector('#services');
const services = JSON.parse(servicesElt.dataset.services);
const motifs = JSON.parse(servicesElt.dataset.motifs);
const depot = document.getElementById('depot');
const motifElt = document.getElementById('motif');
const destockingsDb = JSON.parse(servicesElt.dataset.destockages);
const filteredDestockingsDb = [];
const destockingListElt = document.querySelector('#destocking-list');

const autocomplete = () => {
    let source = services.filter(service => depot.value == service.depotId && service.quantity > 0);

    $("#history").autocomplete({
        minLength: 0,
        source: source,
        focus: (event, ui) => {
            $("#service").val(ui.item.label);
            return false;
        },
        select: (event, ui) => {
            $("#history").val(ui.item.label);
            $("#service").val(ui.item.service);
            $("#depotHistoryId").val(ui.item.historyId);
            return false;
        }
    });
};

const autocompleteMotif = () => {
    $("#motif").autocomplete({
        minLength: 0,
        source: motifs,
        focus: (event, ui) => {
            $("#motif-id").val(ui.item.id);
            return false;
        },
        select: (event, ui) => {
            $("#motif").val(ui.item.label);
            $("#motif-id").val(ui.item.id);
            return false;
        }
    });
};

destockingsDb.forEach((destocking) => {
    if (typeof filteredDestockingsDb.find(d => d.historyId === destocking.historyId) === 'undefined') {
        filteredDestockingsDb.push(destocking);
    }
});

filteredDestockingsDb.forEach((destocking) => {
    if (destocking['quantity'] < 0) {
        let row = `
            <tr>
                <td>${destocking['name']}</td>
                <td>${Math.abs(destocking['quantity'])} ${destocking['symbol'] ?? (typeof destocking['uomName'] === 'string' && destocking['uomName'].trim() !== '' ? (destocking['uomName'] + destocking['quantity'] < -1 ? 's' : '') : '')}</td>
                <td>${destocking['motifDestockage'] ?? '-'}</td>
        `;                    

        if (roles.indexOf('ROLE_GESTSTOCK') !== -1) {
            row += `<td>${destocking['depotName']}</td>`;
        }

        row += '</tr>';

        destockingListElt.innerHTML += row;
    }
    
});

autocomplete();
autocompleteMotif();

depot.addEventListener('change', () => {
    autocomplete();
});

document.getElementById('cancelBtn').addEventListener('click', () => {
    document.querySelectorAll('input:not([type="submit"])').forEach(input => {
        input.value = '';
    });
});

document.getElementById('saveBtn').addEventListener('click', () => {
    const jsonHeaders = new Headers();
    const payload = {
        'depotId': (!!document.getElementById('depot') ? document.getElementById('depot').value : null),
        'service': document.getElementById('service').value,
        'depotHistoryId': Number.parseInt(document.getElementById('depotHistoryId').value, 10),
        'motif': { id: Number.parseInt(document.getElementById('motif-id').value, 10), code: motifElt.value },
        'note': document.getElementById('note').value,
        'nbUnites': document.getElementById('nbUnites').value
    };

    jsonHeaders.append('Content-Type', 'application/json');
    fetch(`${localStorage.getItem('baseUrl')}/depots/destockage`, {
        method: 'POST',
        body: JSON.stringify(payload),
        headers: jsonHeaders
    }).then(resp => {
        if (resp.ok) {
            resp.text().then((respBody) => {
                const { message, data } = JSON.parse(respBody);
                const destockingListInnerHTML = destockingListElt.innerHTML;
                let row = `
                    <tr>
                        <td>${data['product']}</td>
                        <td>${data['quantity']} ${data['symbol'] ?? (typeof data['uomName'] === 'string' && data['uomName'].trim() !== '' ? (data['uomName'] + (data['quantity'] > 1 ? 's' : '')) : '')}</td>
                        <td>${data['reason'] ?? '-'}</td>
                `;
                if (roles.indexOf('ROLE_GESTSTOCK') !== -1) {
                    row += `<td>${data['depot']}</td>`;
                }
                row += '</tr>';
                destockingListElt.innerHTML = row + destockingListInnerHTML;
                document.getElementById('history').value = '';
                showAlert(message, 'success', false);
            });
        } else if (resp.status === 406) {
            showAlert('Vous ne pouvez pas déstocker une quantité supérieure à celle qui est dans le stock.', 'warning', false);
        }
    });
});
