// BOOTSTRAP CORE COMPONENTS
import Button from './bootstrap/src/button.js';
import Carousel from './bootstrap/src/carousel.js';
import Collapse from './bootstrap/src/collapse.js';
import Modal from './bootstrap/src/modal.js';
import Popover from './bootstrap/src/popover.js';
import ScrollSpy from './bootstrap/src/scrollspy.js';
import Tab from './bootstrap/src/tab.js';
import Tooltip from './bootstrap/src/tooltip.js';

// MDB FREE COMPONENTS
import Input from './free/input.js';
import Dropdown from './free/dropdown.js';
import Ripple from './free/ripple.js';

// MDB PRO COMPONENTS
import Animate from './pro/animate.js';
// import Chart from './pro/charts.js';
import Lightbox from './pro/lightbox.js';
import Rating from './pro/rating.js';
import Sidenav from './pro/sidenav.js';
import Alert from './pro/alert.js';
import Toast from './pro/toast.js';
import Timepicker from './pro/timepicker/index.js';
import Navbar from './pro/navbar.js';
import InfiniteScroll from './pro/infiniteScroll.js';
import LazyLoad from './pro/lazyLoad.js';
import Datepicker from './pro/datepicker/index.js';
import Popconfirm from './pro/popconfirm.js';
import Datatable from './pro/datatable/index.js';
import Stepper from './pro/stepper.js';
import Sticky from './pro/sticky.js';
import Select from './pro/select/index.js';
import Touch from './pro/touch/index.js';
import SmoothScroll from './pro/smooth-scroll.js';
import PerfectScrollbar from './pro/perfectScrollbar.js';
import Loading from './pro/loading-management/index.js';
import Autocomplete from './pro/autocomplete/index.js';

// AUTO INIT
[...document.querySelectorAll('[data-toggle="tooltip"]')].map((tooltip) => new Tooltip(tooltip));
[...document.querySelectorAll('[data-toggle="popover"]')].map((popover) => new Popover(popover));

export {
  // FREE
  Button,
  Carousel,
  Collapse,
  Dropdown,
  Input,
  Modal,
  Popover,
  ScrollSpy,
  Ripple,
  Tab,
  Tooltip,
  // PRO
  Alert,
  Animate,
  // Chart,
  Datepicker,
  Datatable,
  Lightbox,
  Navbar,
  Popconfirm,
  Rating,
  Sidenav,
  SmoothScroll,
  Timepicker,
  Toast,
  InfiniteScroll,
  LazyLoad,
  Stepper,
  Sticky,
  Select,
  Touch,
  PerfectScrollbar,
  Loading,
  Autocomplete,
};
