import './styles/new-approvisionnement.css';
import './bootstrap/js/bootstrap';

const servicesFilter = async (query) => {
    const url = `${localStorage.getItem('baseUrl')}/depots/approvisionnement?search=${encodeURI(query.trim())}`;
    const response = await fetch(url, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    const data = await response.json();
    return data;
};
const serviceAutocomplete = document.querySelector('#service');
const dropdownMenu = document.querySelector('#service-dropdown');

window.selectItem = function(event) {
    const codebarElt = document.querySelector('#codeBar');
    const currentTarget = event.currentTarget;
    const codebar = currentTarget.dataset.codebar.trim();

    serviceAutocomplete.value = currentTarget.textContent;
    codebarElt.value = codebar;
    dropdownMenu.style.display = 'none';

    if (codebar !== '') {
        codebarElt.focus();
    }
};

// document.getElementById('cancelBtn').addEventListener('click', () => {
//     document.querySelectorAll('input:not([type="submit"])').forEach(input => {
//         input.value = '';
//     });
// });

serviceAutocomplete.addEventListener('input', (e) => {
    const searchQuery = e.currentTarget.value;

    if (searchQuery.length > 1) {
        const serviceSpinner = document.querySelector('#service-spinner');
        const isCodeBar = searchQuery.split('').every(char => !isNaN(Number.parseInt(char, 10)));
        serviceSpinner.removeAttribute('hidden');

        servicesFilter(searchQuery).then(data => {
            serviceSpinner.setAttribute('hidden', 'hidden');
            dropdownMenu.style.display = 'block';
            if (data.length > 0) {
                if (isCodeBar && data.length === 1) {
                    const codebar = data[0]['codebar'];
                    serviceAutocomplete.value = data[0]['name'];
                    if (typeof codebar === 'string' && codebar.trim() !== '') {
                        const codebarElt = document.querySelector('#codeBar');
                        codebarElt.value = codebar.trim();
                        codebarElt.focus();
                    }
                } else {
                    let listItems = '';
                    data.forEach(item => {
                        listItems += `<li class="dropdown-item" data-codebar="${item.codebar ?? ''}" onclick="selectItem(event)">${item.name}</li>`;
                    });
                    dropdownMenu.innerHTML = listItems;
                }
            } else {
                // dropdownMenu.innerHTML = '<li class="dropdown-item">No results found</li>';
                dropdownMenu.innerHTML = '';
            }
        });
    } else {
        dropdownMenu.style.display = 'none';
    }
});

const searchInput = document.getElementById('datatable-search-input');
const procurementsDatatable = document.querySelector('#procurements-datatable');
const roles = JSON.parse(procurementsDatatable.dataset.roles);
const procurements = JSON.parse(procurementsDatatable.dataset.procurements);
const procurementsDatatableInstance = new mdb.Datatable(procurementsDatatable, {
    columns: [
        { label: 'Article', field: 'item' },
        { label: 'Entrée', field: 'quantity' },
        { label: 'Prix', field: 'price' },
        { label: 'Péremption', field: 'expiration' },
        { label: (roles.indexOf('ROLE_GESTSTOCK') !== -1 ? 'Dépôt' : 'Provenance') , field: 'store' }
    ]
}, { loading: true });

searchInput.addEventListener('input', (event) => {
    const searchQuery = event.currentTarget.value;
    if (searchQuery.length > 1) {
        procurementsDatatableInstance.search(searchQuery);
    }
});

procurementsDatatableInstance.update({
    rows: procurements.map((stock) => {
        return {
            ...stock,
            item: stock.article,
            quantity: `${stock['quantity']} (${stock['uomSymbol'] ?? stock['uomName']}${stock['quantity'] > 1 ? 's' : ''})`,
            expiration: (stock['expirationDate'] ? new Date(stock['expirationDate']['date']).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric'}) : '-'),
            store: (roles.indexOf('ROLE_GESTSTOCK') !== -1 ? stock['storeName'] : (stock['fullName'] ?? stock['username']))
        }
    })
}, { loading: false, hover: true });
