import { groupArrayOfObjects } from "./functions";

const rapportDatatable = document.getElementById('rapport-datatable');
const rapportDataset = rapportDatatable.dataset;
const clotures = JSON.parse(rapportDataset.clotures);
const entries = JSON.parse(rapportDataset.entries);
const outflows = JSON.parse(rapportDataset.outflows);
const spents = JSON.parse(rapportDataset.spents);
const aggregation = groupArrayOfObjects(entries.concat(clotures).concat(outflows).concat(spents), 'createdAt');
const rapport = [];
let index = 0;

for (date in aggregation) {
    if ('undefined' === typeof rapport[index]) {
        rapport.push({date, entries: 0, outflows: 0});
    }

    aggregation[date].forEach((item, idx) => {
        rapport[index][aggregation[date][idx].hasOwnProperty('amountDue') || aggregation[date][idx].hasOwnProperty('provenance') ? 'entries' : 'outflows'] += aggregation[date][idx]['amount'];
    });

    index++;
}

const rapportTableInstance = new mdb.Datatable(rapportDatatable, {
    columns: [
        { label: 'Date', field: 'date' },
        { label: 'Entrées', field: 'entries' },
        { label: 'Sorties', field: 'outflows' }
    ],
    rows: rapport.map(row => {
        return {
            date: `${(new Date(row.date)).toLocaleDateString('fr-FR', {day: 'numeric', month: 'short', year: 'numeric'})}`,
            entries: row.entries.toFixed(2),
            outflows: row.outflows.toFixed(2)
        }
    },
    { hover: true })
},);

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    rapportTableInstance.search(e.target.value);
});
