const usersDatatable = document.querySelector('#users-datatable');
const users = JSON.parse(usersDatatable.dataset.users);
const usersDatatableInstance = new mdb.Datatable(usersDatatable, {
    columns: [
        { label: 'Nom d\'utilisateur', field: 'username' },
        { label: 'Nom complet', field: 'fullName' },
        { label: 'Type', field: 'type' },
        { label: 'Adresse e-mail', field: 'email' },
        { label: 'Téléphone', field: 'telephone' }
    ]
}, { loading: true });

document.getElementById('users-search-input').addEventListener('input', (e) => {
    usersDatatableInstance.search(e.target.value);
});

usersDatatableInstance.update({
    rows: users.map(user => {
        return {
            ...user,
            username: `<a href="/users/${user.id}">${user.username}</a>`
        }
    })
}, { loading: false, hover: true });
