<?php

namespace App\Controller;

use App\AbstractController;
use App\Entity\User;
use App\Entity\Guichet;
use App\Entity\PointOfSale;
use App\Http\ApiResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class GuichetController extends AbstractController
{
    private $montantdispo = 0;

    /**
     * @Route("/guichets/new", name="new_guichet")
     */
    public function new(Request $request)
    {
        return $this->edit('guichets/new.html.twig', $request);
    }

    /**
     * @Route("/guichets/{id}", name="details_guichet")
     */
    public function details(Request $request, int $id)
    {
        return $this->edit('guichets/details.html.twig', $request, $id);
    }

    /**
     * @Route("/guichets", name="list_guichets")
     */
    public function list(Request $request)
    {
        return $this->crud($request, null, Guichet::class, [], 'guichets/list.html.twig', [], ['createdAt' => 'ASC'], null, [
            'title' => 'Guichets',
            'breadcrumb' => [
                ['name' => 'Guichets']
            ]
        ]);
    }

    private function edit(string $template, Request $request, $id = null)
    {
        $em = $this->getDoctrine()->getManager();
        $er = $em->getRepository(PointOfSale::class);
        $eg = $em->getRepository(Guichet::class);
        $us = $em->getRepository(User::class);
        $guichet = null;
        $violationList = [];

        if (isset($id)) {
            $guichet = $eg->find($id);
        }

        if ($request->getMethod() == 'POST') {
            $pos = $er->find((int) $request->request->get('pointOfSale'));
            $user = $this->getUser();
            if (!isset($id)) {
                $guichet = new Guichet();
            }
            $permissions = $request->request->get('permissions');
            $guichet->setNomGuichet(trim($request->request->get('nomGuichet')));
            if (isset($permissions)) {
                $guichet->setTypevente(implode(',', $permissions));
            }
            $pos->addGuichet($guichet);
            $guichet->setMontantdispo($this->montantdispo);
            $user->addGuichet($guichet);

            $violationList = $this->validator->validate($guichet);
            $countViolations = count($violationList);
            $this->get('session')->getFlashBag()->clear();

            if ($countViolations > 0) {
                $message = 'Le formulaire contient des erreurs';
                if ($request->isXMLHttpRequest()) {
                    return new ApiResponse($message, [], $violationList, 500);
                }
                $this->addFlash('danger', $message);
            } else {
                if (!isset($id)) {
                    $em->persist($guichet);
                }
                $em->flush();
                if (isset($id)) {
                    $placeholder = 'modifié';
                } else {
                    $placeholder = 'ajouté';
                }
                $this->addFlash('success', sprintf("Guichet %s avec succès", $placeholder));
            }
        }

        $pointsOfSale = $er->findBy([], ['name' => 'ASC']);
        $latestguichets = $eg->findBy([], ['nomGuichet' => 'ASC']);

        return $this->render($template, [
            'pointsOfSale' => $pointsOfSale,
            'latestguichets' => $latestguichets,
            'currentG' => $guichet,
            'title' => 'Gestion des guichets',
            'breadcrumb' => [
                ['name' => 'Guichets', 'path' => '/guichets'],
                ['name' => isset($id) ? $guichet->getNomGuichet() : 'Nouveau guichet']
            ],
            'violations'=> $violationList
        ]);
    }
}
