<?php

// require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Table;
use PhpOffice\PhpSpreadsheet\Worksheet\Table\TableStyle;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\Filesystem\Filesystem;

$helper = new Sample();
$fs = new Filesystem();

// Create new Spreadsheet object
$helper->log('Create Spreadsheet');
$spreadsheet = new Spreadsheet();

// Set document properties
$helper->log('Set document properties');
// var_dump($sales);
$spreadsheet
    ->getProperties()
    ->setCreator('Reflet')
    ->setLastModifiedBy('Reflet')
    ->setTitle('Rapport des ventes')
    ->setSubject('Rapport des ventes')
    ->setDescription('Test document for PhpSpreadsheet, generated using PHP classes.')
    ->setKeywords('office PhpSpreadsheet php')
    ->setCategory('Table')
;

// Create the worksheet
$helper->log('Add data');

$spreadsheet->setActiveSheetIndex(0);
$activesheet = $spreadsheet->getActiveSheet();
$activesheet
    ->setCellValue('A1', 'Date')
    ->setCellValue('B1', 'Facture')
    ->setCellValue('C1', 'Service/Article')
    ->setCellValue('D1', 'Categorie')
    ->setCellValue('E1', 'Quantité')
    ->setCellValue('F1', 'Montant')
    ->setCellValue('G1', 'Type vente')
    ->setCellValue('H1', 'Client')
;

$dataArray = [];
$count = count($sales);

foreach ($sales as $sale) {
    $createdAt = $sale['createdAt']->format('jS M Y');
    $quantity = abs($sale['quantity']);
    $total = $quantity * $sale['price'];

    $dataArray[] = [
        $createdAt,
        $sale['invoice'],
        $sale['serviceName'],
        $sale['categoryName'],
        $quantity,
        $total,
        $sale['typeFacture'],
        $sale['nomClient'],
    ];
}

$activesheet->fromArray($dataArray, null, 'A2');

// Create Table
$helper->log('Create Table');
$table = new Table('A1:H'.($count + 1), 'Sales_Data');

// Create Columns
// $table->getColumn('H')->setShowFilterButton(false);

// Create Table Style
$helper->log('Create Table Style');
$tableStyle = new TableStyle();
$tableStyle->setTheme(TableStyle::TABLE_STYLE_MEDIUM2);
$tableStyle->setShowRowStripes(true);
$tableStyle->setShowColumnStripes(true);
$tableStyle->setShowFirstColumn(true);
$tableStyle->setShowLastColumn(true);
$table->setStyle($tableStyle);

// Add Table to Worksheet
$helper->log('Add Table to Worksheet');
$activesheet->addTable($table);

// Save
$folder = '/RAPPORTS/';

if (!file_exists($folder)) {
    mkdir($folder, 0777);
}

// $filename = $folder.'rapport-des-ventes-'.((new DateTime())->getTimestamp()).'.xlsx';
$filename = $folder.'rapport-des-ventes-'.((new DateTime())->format('Ymj-His')).'.xlsx';
// $helper->write($spreadsheet, $filename, ['Xlsx']);
$writer = new Xlsx($spreadsheet);
$writer->save($filename);
$helper->log('File saved as '.$filename);

// header('Location: /rapportventes');
