const Encore = require('@symfony/webpack-encore');

// Manually configure the runtime environment if not already configured yet by the "encore" command.
// It's useful when you use tools that rely on webpack.config.js file.
if (!Encore.isRuntimeEnvironmentConfigured()) {
    Encore.configureRuntimeEnvironment(process.env.NODE_ENV || 'dev');
}

Encore
    // directory where compiled assets will be stored
    .setOutputPath('public/build/')
    // public path used by the web server to access the output path
    .setPublicPath('/build')
    // only needed for CDN's or sub-directory deploy
    //.setManifestKeyPrefix('build/')

    /*
     * ENTRY CONFIG
     *
     * Each entry will result in one JavaScript file (e.g. app.js)
     * and one CSS file (e.g. app.css) if your JavaScript imports CSS.
     */
    .addEntry('app', './assets/app.js')
    .addEntry('approvisionnements', './assets/approvisionnements.js')
    .addEntry('categories', './assets/categories.js')
    .addEntry('cautions', './assets/cautions.js')
    .addEntry('clients', './assets/clients.js')
    .addEntry('controle-expertise', './assets/controle-expertise.js')
    .addEntry('currencies', './assets/currencies.js')
    .addEntry('destockage', './assets/destockage.js')
    .addEntry('detail-user', './assets/detail-user.js')
    .addEntry('dettes', './assets/dettes.js')
    .addEntry('expertises', './assets/expertises.js')
    .addEntry('facturesannulees', './assets/facturesannulees.js')
    .addEntry('fichestock', './assets/fichestock.js')
    .addEntry('invoice-cancelation', './assets/invoice-cancelation.js')
    .addEntry('licenses', './assets/licenses.js')
    .addEntry('new-approvisionnement', './assets/new-approvisionnement.js')
    // .addEntry('pouchdb', './assets/pouchdb.min.js')
    // .addEntry('blob-util.min', './assets/blob-util.min.js')
    .addEntry('sale', './assets/sale.js')
    .addEntry('salesreport', './assets/salesreport.js')
    .addEntry('services', './assets/services.js')
    .addEntry('toggle-categories', './assets/toggle-categories.js')
    .addEntry('users', './assets/users.js')
    .addEntry('layout', './assets/layout.js')
    .addEntry('login', './assets/login.js')
    .addEntry('paiements-dettes', './assets/paiements-dettes.js')
    .addEntry('print', './assets/print.js')
    .addEntry('rapport-general', './assets/rapport-general.js')
    .addEntry('spentsreport', './assets/spentsreport.js')
    .addEntry('remove-item', './assets/remove-item.js')
    .addEntry('reception-versement', './assets/reception-versement.js')
    .addEntry('vats', './assets/vats.js')
    .addEntry('valorisation-stock', './assets/valorisation-stock.js')
    .addEntry('vehicles', './assets/vehicles.js')
    // .addStyleEntry('print-invoice', './assets/styles/print-invoice.css')
    .addStyleEntry('export-pdf', './assets/styles/export-pdf.scss')

    // enables the Symfony UX Stimulus bridge (used in assets/bootstrap.js)
    .enableStimulusBridge('./assets/controllers.json')

    // When enabled, Webpack "splits" your files into smaller pieces for greater optimization.
    .splitEntryChunks()

    // will require an extra script tag for runtime.js
    // but, you probably want this, unless you're building a single-page app
    .enableSingleRuntimeChunk()

    /*
     * FEATURE CONFIG
     *
     * Enable & configure other features below. For a full
     * list of features, see:
     * https://symfony.com/doc/current/frontend.html#adding-more-features
     */
    .cleanupOutputBeforeBuild()
    .enableBuildNotifications()
    .enableSourceMaps(!Encore.isProduction())
    // enables hashed filenames (e.g. app.abc123.css)
    .enableVersioning(Encore.isProduction())

    .configureBabel((config) => {
        config.plugins.push('@babel/plugin-proposal-class-properties');
    })

    // enables @babel/preset-env polyfills
    .configureBabelPresetEnv((config) => {
        config.useBuiltIns = 'usage';
        config.corejs = 3;
    })

    // enables Sass/SCSS support
    .enableSassLoader()

    // uncomment if you use TypeScript
    //.enableTypeScriptLoader()

    // uncomment if you use React
    //.enableReactPreset()

    // uncomment to get integrity="..." attributes on your script & link tags
    // requires WebpackEncoreBundle 1.4 or higher
    //.enableIntegrityHashes(Encore.isProduction())

    // uncomment if you're having problems with a jQuery plugin
    //.autoProvidejQuery()
;

module.exports = Encore.getWebpackConfig();
