/*
 * Welcome to your app's main JavaScript file!
 *
 * We recommend including the built version of this JavaScript file
 * (and its CSS file) in your base layout (base.html.twig).
 */

// any CSS you import will output into a single css file (app.css in this case)
import './img/mdb-favicon.ico';
import './fontawesome/css/all.css'; // Font Awesome
import './styles/fonts.css'; // Google Fonts Roboto
import './styles/app.scss';
import * as mdb from './mdb/src/js/mdb.pro';
import showAlert from './toast';
import { setServerIp } from './functions';

// // start the Stimulus application
// import './bootstrap';

window.mdb = mdb;
window.showAlert = showAlert;
window.defaultIp = 'http://127.0.0.1:8000';

let serverIp = localStorage.getItem('baseUrl');

if (serverIp === null) {
    setServerIp();
}

const sidenav = document.getElementById("reflet-sidenav");

if (sidenav) {
    const instance = mdb.Sidenav.getInstance(sidenav);
    const firstSidenavCollapseElement = document.querySelector('.sidenav-item > .ripple-surface-primary:first-child');
    let innerWidth = null;

    const setMode = (e) => {
        // Check necessary for Android devices
        if (window.innerWidth === innerWidth) {
            return;
        }

        innerWidth = window.innerWidth;

        if (window.innerWidth < 768) {
            instance.changeMode("over");
            instance.hide();
        } else {
            instance.changeMode("side");
            instance.show();
        }
    };

    setMode();
    firstSidenavCollapseElement.click();
    setTimeout(() => {
        firstSidenavCollapseElement.click();
    }, 1000);
    // Event listeners
    window.addEventListener("resize", setMode);
}
