const clientsDatatable = document.getElementById('clients-datatable');
const clients = JSON.parse(clientsDatatable.dataset.clients);

const clientsTableInstance = new mdb.Datatable(clientsDatatable, {
    columns: [
        { label: 'Noms', field: 'nomClient' },
        { label: 'Sexe', field: 'sexe' },
        { label: 'Téléphone', field: 'telephone' },
        { label: 'Plainte', field: 'mail' },
        { label: 'Adresse', field: 'adressePhys' },
        { label: 'Type', field: 'typeClient' },
        { label: 'Catégorie', field: 'category' },
        { label: 'Num dossier', field: 'plainteMalade' }
    ],
    rows: clients.map(row => {
        return {
            ...row,
            nomClient: `<a href="${localStorage.getItem('baseUrl')}/clients/${row.id}">${row.nomClient}</a>`,
            typeClient: `Personne ${row.typeClient}`
        }
    })
}, { hover: true });

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    clientsTableInstance.search(e.target.value);
});
