import './usage-vehicule-autocomplete';
import './print.min';
import { getFileFromServer } from './functions';

const maison = JSON.parse(document.querySelector('#maison').dataset.maison);
let categories = JSON.parse(localStorage.getItem('categories')) ?? [];
const vehicleElt = document.querySelector('#vehicle');
const issuesElt = document.querySelector('#issues');
let isUpdate;
const isControle = 'undefined' !== typeof vehicleElt.dataset.invoiceCount;
let controls = JSON.parse(document.querySelector('#controls').dataset.controls);
const dbCategory = vehicleElt.dataset.dbCategory;
let issues = [];
let vehicle = JSON.parse(vehicleElt.dataset.vehicle);
const licenseId = Number.parseInt(vehicleElt.dataset.licenseId, 10);
const registerIssuesModalElt = document.querySelector('.modal');
const spinner = document.querySelector('#spinner');
const registerIssuesModal = new mdb.Modal(registerIssuesModalElt);
let options = [];
const baseUrl = localStorage.getItem('baseUrl');

const categoriesFilter = async (value) => {
    const query = value.trim().toLowerCase();
    const filteredCategories = categories.filter(category => category.name.trim().toLowerCase().indexOf(query) > -1);

    if (filteredCategories.length > 0) {
        return new Promise((resolve) => {
            resolve(filteredCategories);
        });
    }

    const response = await fetch(`${localStorage.getItem('baseUrl')}/categories?search=${encodeURI(query)}&limit=10`, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    const data = await response.json();
    categories = data.data;

    return data.data;
};

const optionsFilter = (value) => {
    if (options.length === 0) {
        fetchObservations();
        return [];
    }

    return options.filter(option => option.name.toLowerCase().indexOf(value.trim().toLowerCase()) > -1);
};

window.addNewObservation = function() {
    const observation = prompt('Nom de l\'observation');
    if (typeof observation === 'string' && observation.trim() !== '') {
        spinner.removeAttribute('hidden');
        fetch(`${localStorage.getItem('baseUrl')}/create-observation-controle-technique`, {
            method: 'POST',
            body: JSON.stringify({name: observation}),
            headers: new Headers({'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest'}),
        }).then((response) => {
            if (response.ok) {
                response.text().then((respBody) => {
                    const { message, data } = JSON.parse(respBody);
                    spinner.setAttribute('hidden', 'hidden');
                    options.unshift(data);
                    showAlert(message, 'success', false);
                });
            }
        });
    }
};

window.setObservation = function() {
    const currentTarget = event.currentTarget;
    const ancestor = currentTarget.parentNode.parentNode.parentNode;
    const observationInput = document.getElementById(ancestor.querySelector('input').id);
    const dataset = currentTarget.dataset;
    const serviceId = observationInput.id.split(['-'][1]);
    observationInput.dataset.observationId = dataset.id;
    observationInput.dataset.observationSlug = dataset.slug;
    observationInput.dataset.observationName = currentTarget.textContent;
    observationInput.value = currentTarget.textContent;
    ancestor.querySelector('.dropdown').style.display = 'none';
    updateIssues(observationInput);
};

window.pickObservation = function() {
    const currentTarget = event.currentTarget;
    const inputId = currentTarget.id;
    const searchQuery = currentTarget.value;
    const index = currentTarget.dataset.index;
    const dropdown = currentTarget.parentNode.querySelector('.dropdown');

    if (searchQuery.length > 1) {
        const spinner = document.querySelector('#observation-spinner' + index);
        const filteredOptions = optionsFilter(searchQuery);

        if (filteredOptions.length > 0) {
            const dropdownMenu = dropdown.querySelector('.dropdown-menu');
            let listItems = '';
            dropdown.style.display = 'block';
            dropdownMenu.style.display = 'block';
            filteredOptions.forEach((item) => {
                listItems += `<li class="dropdown-item" data-input-id="${inputId}" data-index="${index}" data-id="${item.id}" data-slug="${item.slug}" data-name="${item.name}" onclick="setObservation()">${item.name}</li>`;
            });
            dropdownMenu.innerHTML = listItems;
        } else {
            dropdown.style.display = 'none';
        }
    } else {
        dropdown.style.display = 'none';
    }
};

function getIssue(service, index) {
    return `
        <div class="d-flex justify-content-between align-items-center pl-4 pr-2 py-1 my-3 border border-primary shadow-sm" style="background: linear-gradient(#fff 0%, #eee 60%, #ccc 100%); border-radius: 4px;">
            <div class="form-check" style="width: 50%">
                <input data-index="${index}" style="box-shadow: inset #ddd 0 2px 2px;" class="form-check-input" type="checkbox" id="issue-${service.id}"${service.checked ? ' checked' : ''} />
                <label class="form-check-label" for="issue-${service.id}">${service.name}</label>
            </div>
            <div class="d-flex flex-row" style="width: 50%">
                <input data-index="${index}" type="number" min="0" step="1" class="form-control mr-2" id="quantity-${service.id}" name="quantity-${service.id}" value="${service.quantity}" min="1" style="border-color: #aaa !important; width: 50%; box-shadow: inset #ddd 0 2px 2px;">
                <div>
                    <input data-index="${index}" type="text" oninput="pickObservation()" class="form-control" id="observation-${service.id}" name="observation-${service.id}" style="border-color: #aaa !important; box-shadow: inset #ddd 0 2px 2px;" value="${typeof service.observation === 'string' ? service.observation : ''}">
                    <div class="dropdown w-100 mt-0">
                        <ul class="dropdown-menu border shadow-sm w-100 mt-0" id="observation-dropdown-${index}"></ul>
                    </div>
                </div>
            </div>
        </div>
    `;
}

// <select data-index="${index}" id="observation-${service.id}" name="observation-${service.id}" class="select" style="border-color: #aaa !important; border-radius: 4px;">${selectInnerHTML}</select>

window.updateIssues = function(input) {
    const serviceId = input.id.split('-')[1];
    const checkbox = document.querySelector(`#issue-${serviceId}`);
    const select = document.querySelector(`#observation-${serviceId}`);
    const qtyInput = document.querySelector(`#quantity-${serviceId}`);
    const anomalie = { id: Number.parseInt(serviceId, 10), name: checkbox.parentNode.querySelector('label').textContent, observation: (event.type === 'input' ? select.value : select.dataset.observationName), quantity: Number.parseFloat(qtyInput.value), checked: checkbox.checked };
    issues.splice(Number.parseInt(input.dataset.index, 10), 1, anomalie);
};

window.attachChangeEvent = function(element) {
    element.addEventListener('input', (e) => {
        updateIssues(e.currentTarget);
    });
};

window.addNewItem = function(event) {
    const category = document.querySelector('#category').dataset.categoryId;
    const service = prompt("Entrer le nom de la nouvelle panne");
    
    if (!!service && typeof category === 'string') {
        // window.scrollTo(0, 0);
        spinner.removeAttribute('hidden');

        fetch(`${localStorage.getItem('baseUrl')}/services/addnewpanne`, {
            method: 'POST',
            headers: new Headers({'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest'}),
            body: JSON.stringify({ category, service })
        }).then(resp => {
            spinner.setAttribute('hidden', 'hidden');

            if (resp.ok) {
                resp.text().then(respBody => {
                    const { data } = JSON.parse(respBody);

                    if (data.serviceId > 0) {
                        const newIssue = { id: data['serviceId'], name: data['name'], observation: options[0]['value'], quantity: 1, checked: true };
                        issues.unshift(newIssue);
                        populateCheckboxList(issues);
                        showAlert('Panne ajoutée avec succès', 'success', false);
                    } else {
                        showAlert('Ajout échoué', 'danger', false);
                    }
                });
            } else {
                resp.text().then(respBody => {
                    let message = '';
                    const { errors } = JSON.parse(respBody);
                    issuesElt.innerHTML = '';
                    populateCheckboxList(issues);

                    for (const key in errors) {
                        errors[key].forEach(error => {
                            message += error.message;
                        });
                    }

                    showAlert(0 < message.length ? message : 'Une erreur est survenue', 'danger', false);
                });
            }
        });
    }
};

window.populateCheckboxList = function(issues) {
    const issuesNumber = issues.length;
    let issuesInnerHtml = '';
    issuesElt.innerHTML = '';

    if (issuesNumber > 0) {
        const mean = Math.ceil(issuesNumber / 2);

        for (let i = 0; i < mean; i++) {
            issuesInnerHtml += getIssue(issues[i], i);
        }

        issuesInnerHtml = '<div class="col-sm-12 col-md-6">' + issuesInnerHtml + '</div>';
        issuesElt.innerHTML = issuesInnerHtml;

        if (issuesNumber > 1) {
            issuesInnerHtml = '';

            for (let i = mean; i < issuesNumber; i++) {
                issuesInnerHtml += getIssue(issues[i], i);
            }

            issuesInnerHtml = '<div class="col-sm-12 col-md-6">' + issuesInnerHtml + '</div>';
            issuesElt.innerHTML += issuesInnerHtml;
        }

        document.querySelectorAll(`[id^="issue-"], [id^="quantity-"], [id^="observation-"]`).forEach(elt => {
            attachChangeEvent(elt);
        });
    }
};

window.fetchServices = function(event = null, category = null) {
    let currentCategory;
    const localStorageCategories = localStorage.getItem('categories');

    if (null !== event) {
        const currentTarget = event.currentTarget;
        currentCategory = { id: Number.parseInt(currentTarget.dataset.id), name: currentTarget.textContent };
    } else {
        currentCategory = category;
    }

    if (!localStorageCategories) {
        localStorage.setItem('categories', JSON.stringify([currentCategory]));
    } else {
        const cats = JSON.parse(localStorageCategories);
        if (cats.length === 100) {
            cats.pop();
        }
        if ('undefined' === typeof cats.find(cat => cat.id === currentCategory.id)) {
            cats.unshift(currentCategory);
            localStorage.setItem('categories', JSON.stringify(cats));
        }
    }

    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/services?c=${currentCategory.id}`, {
        method: 'GET',
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    }).then(response => {
        document.querySelector(`#category-dropdown`).style.display = 'none';

        if (response.ok) {
            response.text().then(respBody => {
                const { data } = JSON.parse(respBody);
                spinner.setAttribute('hidden', 'hidden');
                document.querySelector('#category').dataset.categoryId = currentCategory.id;
                updateVehicle(currentCategory.name, false);
                document.querySelector('#add-observation-btn').removeAttribute('hidden');
                document.querySelector('#add-issue-btn').removeAttribute('hidden');

                if (data.length > 0) {
                    const completeIssue = (item) => {
                        Object.assign(item, { observation: (options.length > 0 ? options[0]['value'] : ''), quantity: 1, checked: false });
                        return item;
                    };

                    if (controls.length > 0) {
                        issues = data.map(issue => {
                            const match = controls.find(control => control.id === issue.id);
                            if ('undefined' !== typeof match) {
                                const result = { id: match.id, name: match.name, observation: match.observation, quantity: match.quantity, checked: true };
                                return result;
                            }
                            return completeIssue(issue);
                        });
                    } else {
                        issues = data.map(issue => completeIssue(issue));
                    }
                }

                populateCheckboxList(issues);
            });
        }
    });
};

window.addCategory = function(categoryName = null) {
    const name = (categoryName ?? prompt("Entrer le modèle du véhicule")).trim();

    if (!!name) {
        spinner.removeAttribute('hidden');

        fetch(`${localStorage.getItem('baseUrl')}/categories/new`, {
            method: 'POST',
            headers: new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }),
            body: JSON.stringify({ name })
        }).then(response => {
            spinner.setAttribute('hidden', 'hidden');

            if (response.ok) {
                response.text().then(respBody => {
                    const { data, message } = JSON.parse(respBody);
                    const categoryInput = document.querySelector('#category');
                    issues = [];
                    populateCheckboxList(issues);
                    categoryInput.value = '';
                    categoryInput.dataset.categoryId = data['id'];
                    updateVehicle(data['name'], false);
                    document.querySelector('#add-observation-btn').removeAttribute('hidden');
                    document.querySelector('#add-issue-btn').removeAttribute('hidden');
                    showAlert(message, 'success', false);
                });
            } else {
                response.text().then(respBody => {
                    const { errors } = JSON.parse(respBody);
                    let message = '';
                    for (const key in errors) {
                        const errorsByPath = errors[key];
                        errorsByPath.forEach(error => {
                            message += error['message'];
                        });
                        showAlert(message, 'danger', false);
                    }
                });
            }
        });
    } else {
        showAlert(`Le nom "${name}" que vous avez saisi n'est pas valide.`, 'danger', false);
    }
};

window.updateVehicle = function(modele = null, vehicleAlert = true) {
    if (null !== modele) {
        const title = `${isControle ? 'Contrôle technique' : 'Expertise de vehicule'} ${modele} (${vehicle['numeroImmatriculation']}), ${document.querySelector('#client').value}`;
        document.querySelector('#typeOuModele').value = modele;
        document.querySelector('#category-name').textContent = modele;
        document.querySelector('#clotureModalLabel').textContent = title;
        document.querySelector('#main-title').textContent = title;
        vehicle['typeOuModele'] = modele;
    }

    fetch(`${localStorage.getItem('baseUrl')}/vehicule/${vehicle['id']}`, {
        method: 'POST',
        headers: new Headers({'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest'}),
        body: JSON.stringify(vehicle)
    }).then(response => {
        if (response.ok) {
            response.text().then(respBody => {
                if (vehicleAlert) {
                    const { message } = JSON.parse(respBody);
                    showAlert(message, 'success', false);
                }
            });
        }
    });
};

window.printControleTechnique = function() {
    const controleTechniqueTemplate = document.querySelector('#rapport-controle-technique');
    let tbody = '';
    let table;
    const footer = `
        <div id="rapport-controle-technique-footer">
            <div class="text-right mt-3">Fait à Goma, ${(new Date()).toLocaleDateString('fr-FR', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' })}</div>
            <div class="text-right mt-5">Nom et signature de l'expert</div>
            <div class="text-right mt-2 font-weight-bold">${document.querySelector('#expert').value.trim()}</div>
        </div>
    `;

    controls.forEach((control, index, arr) => {
        tbody += `
            <tr>
                <td class="text-center">${index + 1}</td>
                <td>${control.name}</td>
                <td class="text-center">${control.quantity}</td>
                <td>${control.observation}</td>
            </tr>
        `;
    });

    table = `
        <div class="border border-dark pb-2">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th class="font-weight-bold text-center">N°</th>
                        <th class="font-weight-bold">ANOMALIES&nbsp;CONSTATEES</th>
                        <th class="font-weight-bold text-center">QTE</th>
                        <th class="font-weight-bold">OBSERVATION</th>
                    </tr>
                </thead>
                <tbody>${tbody}</tbody>
            </table>
        </div>
    `;

    controleTechniqueTemplate.innerHTML = table + footer;
    controleTechniqueTemplate.removeAttribute('hidden');

    printJS({
        printable: 'rapport-controle-technique',
        type: 'html',
        header: `
            <div id="rapport-controle-technique-logo">
                ${maison['logo'] !== null ? '<img src="/uploads/logos/' + maison['logo'] + '" alt="Logo entreprise" class="w-25">' : '<h2 class="w-25">' + maison['nomSociete'] + '</h2>'}
            </div>
            <h4 class="text-center font-weight-bold my-3 pb-1 border-bottom border-dark w-100">RAPPORT ${isControle ? 'CONTROLE TECHNIQUE' : 'EXPERTISE'} DU VEHICULE</h4>
            <div class="d-flex flex-row mb-3">
                <table class="mr-5">
                    <tr><td>Genre</td><td>:</td><td class="font-weight-bold">${vehicle['genre']}</td></tr>
                    <tr><td>Marque</td><td>:</td><td class="font-weight-bold">${vehicle['marque']}</td></tr>
                    <tr><td>Modèle</td><td>:</td><td class="font-weight-bold">${vehicle['typeOuModele']}</td></tr>
                </table>
                <table class="ml-5">
                    <tr><td>Plaque</td><td>:</td><td class="font-weight-bold">${vehicle['numeroImmatriculation']}</td></tr>
                    <tr><td>Kilométrage</td><td>:</td><td class="font-weight-bold">${vehicle['kilometrage']}</td></tr>
                    <tr><td>Client</td><td>:</td><td class="font-weight-bold">${document.querySelector('#client').value}</td></tr>
                </table>
            </div>
        `,
        css: ['/public/build/app.css', '/assets/css/controle-technique.css']
    });

    controleTechniqueTemplate.setAttribute('hidden', 'hidden');
};

function fetchObservations() {
    fetch(`${localStorage.getItem('baseUrl')}/observations-controle-technique`, {
        method: 'GET'
    }).then((response) => {
        if (response.ok) {
            response.text().then((respBody) => {
                const { data } = JSON.parse(respBody);
                options = data;
            });
        }
    });
}

fetchObservations();

if (isControle) {
    isUpdate = Number.parseInt(vehicleElt.dataset.invoiceCount, 10) > 0;
} else {
    isUpdate = 'undefined' !== typeof controls.find(control => null !== control.updatedAt);
}

document.querySelectorAll('#vehicle-form input').forEach(input => {
    input.addEventListener('change', (event) => {
        const currentTarget = event.currentTarget;
        vehicle[currentTarget.id] = currentTarget.id === 'client' ? currentTarget.dataset.clientId : currentTarget.value;
        updateVehicle(currentTarget.id === 'typeOuModele' ? currentTarget.value : null);
    });
});

document.querySelector('#category').addEventListener('keyup', (event) => {
    const searchQuery = event.currentTarget.value;
    const dropdownMenu = document.querySelector('#category-dropdown');
    if (searchQuery.length > 1) {
        const spinner = document.querySelector('#category-spinner');
        spinner.removeAttribute('hidden');
        categoriesFilter(searchQuery).then(data => {
            spinner.setAttribute('hidden', 'hidden');
            dropdownMenu.style.display = 'block';
            if (data.length > 0) {
                let listItems = '';
                data.forEach(item => {
                    listItems += `<li class="dropdown-item" data-id="${item.id}" onclick="fetchServices(event)">${item.name}</li>`;
                });
                dropdownMenu.innerHTML = listItems;
            } else {
                dropdownMenu.innerHTML = '<li class="dropdown-item">No results found</li>';
            }
        });
    } else {
        dropdownMenu.style.display = 'none';
    }
});

// document.querySelector('#print-btn').addEventListener('click', printControleTechnique);

document.querySelector('#submit-issues-btn').addEventListener('click', (e) => {
    e.preventDefault();
    e.stopPropagation();
    const expertInput = document.querySelector('#expert');

    if (!(expertInput.value.trim())) {
        showAlert('Le nom de l\'expert est obligatoire.', 'danger', false);
    } else {
        const url = baseUrl + (isControle ? `/controletechnique${isUpdate ? '' : '/new'}/${licenseId}` : `/expertises/${isUpdate ? 'updateissues' : 'addissues'}/${licenseId})`);
        const payload = { issues: issues.filter(issue => issue.checked), expert: expertInput.value.trim() };
        spinner.removeAttribute('hidden');

        fetch(url, {
            headers: new Headers({'Content-Type': 'application/json'}),
            method: 'POST',
            body: JSON.stringify(payload)
        }).then(response => {
            spinner.setAttribute('hidden', 'hidden');
            if (response.ok) {
                response.text().then(resp => {
                    const data = JSON.parse(resp);
                    isUpdate = true;
                    controls = data.controls;
                    options = data.observations;
                    showAlert('Opération effectuée avec succès', 'success', false);
                    // window.location.assign(`${localStorage.getItem('baseUrl')}/controlexpertise/${isControle ? 'control' : 'expertise'}/${licenseId}/export-pdf`);
                    printReport();
                    // setTimeout(() => {
                    //     printControleTechnique();
                    // }, 5000);
                });
            } else {
                showAlert('Une erreur est survenue', 'danger', false);
            }
        });
    }
});

registerIssuesModalElt.addEventListener('shown.bs.modal', (e) => {
    const categoryName = [null, undefined].indexOf(dbCategory) === -1 && ('string' === typeof dbCategory && '' !== dbCategory.trim())
        ? dbCategory
        : document.querySelector('#typeOuModele').value
    ;
    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/categories?search=${encodeURI(categoryName.trim())}&limit=1`, {
        headers: {'X-Requested-With': 'XMLHttpRequest'}
    }).then(response => {
        if (response.ok) {
            response.text().then(respBody => {
                const { data } = JSON.parse(respBody);
                spinner.setAttribute('hidden', 'hidden');
                if (data.length === 1) {
                    fetchServices(null, data[0]);
                } else {
                    const name = prompt(`Le modèle "${categoryName}" n'existe pas dans le système. Voulez-vous l'ajouter ?`, categoryName);
                    if ('string' === typeof name) {
                        addCategory(name.trim());
                    }
                }
            });
        }
    });
});

document.querySelector('#register-issues-button').addEventListener('click', () => {
    registerIssuesModal.show();
});

window.printReport = async () => {
    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');
    // console.log(invoice);
    const url = `${localStorage.getItem('baseUrl')}/controlexpertise/${isControle ? 'control' : 'expertise'}/${licenseId}/export-pdf`;
    const blob = await getFileFromServer(url);
    spinner.setAttribute('hidden', 'hidden');
    printJS({ printable: URL.createObjectURL(blob), type: 'pdf' });
};
