import showAlert from './toast';

export function setServerIp() {
    const serverIp = prompt('Entrez l\'adresse du serveur', window.defaultIp);
    localStorage.setItem('baseUrl', serverIp ?? window.defaultIp);
}

export function groupArrayOfObjects(list, key) {
    return list.reduce(function(rv, x) {
        (rv[x[key]] = rv[x[key]] || []).push(x);
        return rv;
    }, {});
};

export function toCamelCase(word) {
    let result = '';
    const fragments = word.split('-');

    fragments.forEach((fragment, idx) => {
        result += idx === 0 ? fragment : fragment.slice(0, 1).toUpperCase() + fragment.slice(1, fragment.length);
    });

    return result;
}

export function step(number, direction) {
    // number must be a strict positive number, and direction 1 (increment) or -1 (decrement).
    if ((typeof number !== 'number' && number > 0) || [-1, 1].indexOf(direction) === -1) {
        return;
    }

    // // If number is an integer, increment or decrement, then return.
    // if (Math.trunc(number) == number) {
    //     return direction;
    // }

    return direction / 10;
}

export function formatNumber(number) {
    const integer = Math.floor(number);
    if (integer == number) {
        return integer;
    }
    return Number.parseFloat(number.toFixed(1));
}

export async function getFileFromServer(url, headers = null, body = null) {
    const options = {};

    if (!Object.is(headers, null)) {
        const headersObj = new Headers();
        for (const name in headers) {
            if (Object.hasOwnProperty.call(headers, name)) {
                headersObj.set(name, headers[name]);
            }
        }
        Object.assign(options, { headers: headersObj });
    }

    if (Object.is(body, null)) {
        Object.assign(options, { method: 'GET' });
    } else {
        Object.assign(options, { method: 'POST', body });
    }

    const response = await fetch(url);

    if (response.status !== 200) {
        showAlert('Unable to download file.', 'danger', false);
    }

    const blob = await response.blob();

    return blob;
}

export async function downloadFile(url, filename, body = null) {
    try {
        const response = await fetch(url);

        if (response.status !== 200) {
            showAlert('Unable to download file.', 'danger', false);
        }

        const blob = await response.blob();

        // Create a download link
        const downloadLink = document.createElement('a');
        downloadLink.href = URL.createObjectURL(blob);
        downloadLink.download = filename;

        // Trigger the download
        document.body.appendChild(downloadLink);
        downloadLink.click();

        // Clean up
        setTimeout(() => {
            URL.revokeObjectURL(downloadLink.href);
            document.body.removeChild(downloadLink);
        }, 100);
    } catch (error) {
        console.error('Error downloading the file:', error.message);
    }
}
