<?php

namespace App\Tools;

// use Denisok94\SymfonyExportXlsxBundle\Service\XlsxService;
use App\Tools\Mpdf\Mpdf;
use Mpdf\Output\Destination;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\HttpKernel\KernelInterface;
// use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;
use Twig\Environment;

final class Exporter
{
    private $currentUser;

    public function __construct(
        // private XlsxService $exportXlsx,
        private TranslatorInterface $translator,
        private Security $security,
        private Environment $twig,
        private SluggerInterface $slugger,
        private KernelInterface $appKernel
    )
    {
        $this->currentUser = $security->getUser();
    }

    // public function exportXlsx(array $data, array $fields, string $fileName): array
    // {
    //     $data = $this->formatData($data, $fields);
    //     $tempFile = \tempnam(\sys_get_temp_dir(), $fileName);
    //     $this->exportXlsx->setFile($tempFile)->open();
    //     $username = $this->currentUser->getUserIdentifier();
    //     $fileName = $this->translator->trans($fileName);
    //     $slug = \strtolower($this->slugger->slug($fileName));

    //     $this->exportXlsx->getProperties()
    //         ->setCreator($username)
    //         ->setLastModifiedBy($username)
    //         ->setSubject($fileName)
    //         ->setTitle($fileName)
    //     ;

    //     foreach ($data as $line) {
    //         $this->exportXlsx->write($line);
    //     }

    //     $this->exportXlsx->getActiveSheet()->setTitle($fileName);
    //     $this->exportXlsx->close();

    //     return [$tempFile, $slug.'.xlsx', ResponseHeaderBag::DISPOSITION_INLINE];
    // }

    public function exportPdf(string $template, mixed $data, array $fields, string $fileName, array $options = [])
    {
        if (\is_array($data)) {
            $data = $this->formatData($data, $fields);
        }

        $username = $this->currentUser->getUsername();
        $fileName = $this->translator->trans($fileName);
        $slug = \strtolower($this->slugger->slug($fileName));
        $config = ['default_font' => 'dejavusans'];

        if (isset($options['config'])) {
            foreach ($options['config'] as $key => $value) {
                $config[$key] = $value;
            }
        }

        if (\str_contains($template, 'roll')) {
            $config['margin_left'] = 0;
            $config['margin_right'] = 0;
            $config['margin_top'] = 0;
            $config['margin_bottom'] = 0;
        }

        $mpdf = new Mpdf($config);
        // $mpdf->defaultheaderline = 0; //remove this if you want the line
        $mpdf->showImageErrors = true;
        // $mpdf->SetJS('this.print();');
        if (isset($options['pageHeader'])) {
            $mpdf->setHeader($options['pageHeader']); // Example of page header: '|'.$fileName.'|'
        }
        if (isset($options['pageFooter'])) {
            $mpdf->setFooter($options['pageFooter']);
        }
        $mpdf->SetTitle($fileName);
        $mpdf->SetAuthor($username);
        $mpdf->SetCreator('Reflet');
        $mpdf->WriteHTML($this->twig->render($template, ['data' => $data, 'fileName' => $fileName, 'options' => $options]));
        $mpdf->Output(\strtolower($slug).'.pdf', Destination::DOWNLOAD);
    }

    private function formatData(array $rawData, array $fields): array
    {
        $data = [];
        $rawData = $this->swap($rawData, \array_column($fields, 'name'));
        // dd($rawData);

        foreach ($rawData as $index => $row) {
            foreach ($row as $columnKey => $columnValue) {
                if (!\in_array($columnKey, $fields) && \is_array($columnValue)) {
                    foreach ($fields as $property) {
                        $propertyParts = \explode('.', $property['name']);
                        $found = \count($propertyParts) > 1 && $columnKey === $propertyParts[0] && \array_key_exists($propertyParts[1], $columnValue);
                        if ($found) {
                            $columnKey = $property['name'];
                            $columnValue = $columnValue[$propertyParts[1]];
                            break;
                        }
                    }
                }
                $filtered = \array_values(\array_filter($fields, fn ($property) => $property['name'] === $columnKey));
                if (\count($filtered) > 0) {
                    $data[$index][$this->translator->trans($filtered[0]['label'])] = \in_array($filtered[0]['name'], ['createdAt', 'updatedAt'])
                        ? (\is_string($columnValue) ? \explode('T', $columnValue)[0] : $columnValue->format('Y-m-d'))
                        : (\is_float($columnValue) ? \abs(\round($columnValue, 3, PHP_ROUND_HALF_UP)) : $columnValue)
                    ;
                }
            }
        }

        return $data;
    }

    private function swap(array $source, array $columns): array
    {
        // dd($source);
        $swapped = [];

        foreach ($source as $line) { // line e.g. ['quantity' => 9.2, 'service' => 'Farine']
            $newLine = [];
            // dd($columns);

            foreach ($columns as $column) {
                $columnParts = \explode('.', $column);
                $countColumnParts = \count($columnParts);
                // dd($countColumnParts);
                switch ($countColumnParts) {
                    case 1:
                        $newLine[$column] = $line[$columnParts[0]];
                        break;
                    case 2:
                        $newLine[$column] = $line[$columnParts[0]][$columnParts[1]];
                        break;
                    default:
                        break;
                }
                // dd($newLine);
                if (\is_array($newLine[$column])) {
                    $newLine[$column] = $this->reduceArray($newLine[$column]);
                }
            }

            // dd($newLine);

            $swapped[] = $newLine;
        }

        return $swapped;
    }

    private function reduceArray(array $source): string
    {
        $reduced = '';

        if (\array_is_list($source)) {
            $collection = [];
            foreach ($source as $item) {
                if (\array_key_exists('name', $item)) {
                    $collection[] = $item['name'];
                } elseif (\array_key_exists('service', $item) && \array_key_exists('quantity', $item)) {
                    $collection[] = \round(\abs($item['quantity']), 3, PHP_ROUND_HALF_UP).' '.$item['service']['uom']['name'].' '.$item['service']['name'];
                }
            }
            $reduced = \implode(', ', $collection);
        } elseif (\array_key_exists('fullName', $source)) {
            $reduced = $source['fullName'];
        } elseif (\array_key_exists('username', $source)) {
            $reduced = $source['username'];
        } elseif (\array_key_exists('name', $source)) {
            $reduced = $source['name'];
        }

        return $reduced;
    }
}
